<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Role;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class CashierPermissionSeeder extends Seeder
{
    use DisableForeignKeys;
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();

        $cashier = Role::query()
            ->where('id', 5) //Cashier
            ->first();

        $cashier->permissions()->attach([1, 39, 97, 98, 101, 112, 113, 114, 115]);

        $this->enableForeignKeys();
    }
}
