import DatatableHelperMixin from "../../../common/Mixin/Global/DatatableHelperMixin";
import {SUPPLIER_REPORT} from "../../Config/ApiUrl-CPB";
import {axiosGet, urlGenerator} from "../../../common/Helper/AxiosHelper";
import {SelectableBranches} from "../../../store/Tenant/Mixins/BranchMixin";
import {SelectableSuppliers} from "../../../store/Tenant/Mixins/SupplierSelectableMixin";
import {SelectableReceivedBy} from "../../../store/Tenant/Mixins/ReceivedByMixin";
import SelectableStatusMixin from "../../Helper/SelectableOptions/SelectableStatusMixin";
import {mapGetters} from "vuex";
import {numberWithCurrencySymbol} from "../../Helper/Helper";

export default {
    mixins: [DatatableHelperMixin, SelectableBranches, SelectableSuppliers, SelectableReceivedBy, SelectableStatusMixin],
    data() {
        return {
            options: {
                name: this.$t('tenant_groups'),
                // url: SUPPLIER_REPORT,
                url: null,
                showCount: true,
                showClearFilter: true,
                showHeader: true,
                customerGroup: null,
                columns: [
                    {
                        title: this.$t('name'),
                        type: 'text',
                        key: 'name',
                    },
                    {
                        title: this.$t('supplier_no'),
                        type: 'text',
                        key: 'supplier_no',
                    },
                    // {
                    //     title: this.$t('Date'),
                    //     type: 'text',
                    //     key: 'created_at',
                    // },
                    {
                        title: this.$t('branch_or_warehouse'),
                        type: 'component',
                        key: 'lots',
                        componentName: 'app-branch-warehouse',
                    },
                    // {
                    //     title: this.$t('supplier'),
                    //     type: 'custom-html',
                    //     key: 'supplier',
                    //     modifier: (supplier) => supplier && `<span class="text-primary">${supplier.name}</span>`,
                    // },
                    // {
                    //     title: this.$t('total_items'),
                    //     type: 'text',
                    //     key: 'total_unit',
                    // },
                    {
                        title: this.$t('status'),
                        type: 'custom-html',
                        key: 'status',
                        isVisible: true,
                        modifier: (value) => {
                            return `<span class="badge badge-pill badge-${value.class}">${value.translated_name}</span>`;
                        }
                    },
                    // {
                    //     title: this.$t('reference_no'),
                    //     type: 'custom-html',
                    //     key: 'reference_no',
                    //     modifier: (value) => {
                    //         return `<span class="badge badge-pill badge-${value.class}">${value.translated_name}</span>`;
                    //     }
                    // },
                    {
                        title: this.$t('total_purchase'),
                        type: 'custom-html',
                        key: 'total_purchase',
                        titleAlignment: 'right',
                        modifier: value => value ? `<p class="text-right mb-0">${numberWithCurrencySymbol(value)}</p>` : `<p class="text-right mb-0">${numberWithCurrencySymbol(0)}</p>`
                    },
                    // {
                    //     title: this.$t('other_cost'),
                    //     type: 'custom-html',
                    //     key: 'other_charge',
                    //     titleAlignment: 'right',
                    //     modifier: value => value ? `<p class="text-right mb-0">${numberWithCurrencySymbol(value)}</p>` : `<p class="text-right mb-0">${numberWithCurrencySymbol(0)}</p>`
                    // },
                    // {
                    //     title: this.$t('grand_total'),
                    //     type: 'custom-html',
                    //     key: 'total_amount',
                    //     titleAlignment: 'right',
                    //     modifier: value => value ? `<p class="text-right mb-0">${numberWithCurrencySymbol(value)}</p>` : `<p class="text-right mb-0">${numberWithCurrencySymbol(0)}</p>`
                    // },
                ],

                // actionType: "dropdown",
                filters: [
                    // {
                    //     title: this.$t('created_date'),
                    //     type: 'range-picker',
                    //     key: 'date',
                    //     option: ['today', 'last7Days', 'lastMonth', 'thisMonth']
                    // },
                    // {
                    //     title: this.$t('branch_or_warehouse'),
                    //     type: 'search-and-select-filter',
                    //     key: 'branch_or_warehouse',
                    //     settings: {
                    //         url: urlGenerator('app/selectable-branches-or-warehouses'),
                    //         modifire: ({id, name}) => ({id, name}),
                    //         params: {},
                    //         per_page: 10,
                    //         queryName: 'search_by_name',
                    //         loader: 'app-pre-loader'
                    //     },
                    //     listValueField: 'name'
                    // },
                    {
                        title: this.$t('supplier'),
                        type: 'search-and-select-filter',
                        key: 'supplier',
                        settings: {
                            url: urlGenerator('app/selectable-suppliers'),
                            params: {},
                            per_page: 10,
                            queryName: 'search_by_name',
                            loader: 'app-pre-loader',
                            modifire: (value) => (value ? {
                                id: value.id,
                                name: value?.name
                            } : null),
                        },
                        listValueField: 'name',
                    },
                    // {
                    //     title: this.$t('created_by'),
                    //     type: 'search-and-select-filter',
                    //     key: "created_by",
                    //     settings: {
                    //         url: urlGenerator('app/selectable/users'),
                    //         modifire: ({id, full_name}) => ({id, full_name}),
                    //         params: {},
                    //         per_page: 10,
                    //         queryName: 'search_by_first_or_last_name',
                    //         loader: 'app-pre-loader'
                    //     },
                    //     listValueField: 'full_name'
                    // },
                    this.getStatusFilterOptions('supplier'),
                ],
                paginationType: "pagination",
                responsive: true,
                rowLimit: 10,
                showAction: true,
                orderBy: 'desc',
                search: true,
            },
        }
    },
    created() {
    },
    // methods: {
    //     updateUrl() {
    //         this.options.url = `${SUPPLIER_REPORT}?branch_or_warehouse_id=${this.getBranchOrWarehouseId}`
    //         this.$hub.$emit(`reload-${this.table_id}`)
    //     }
    // },
    computed: {
        ...mapGetters(['getBranchOrWarehouseId']),
    },
    mounted() {
        this.updateUrl(SUPPLIER_REPORT);
    },
    watch: {
        getBranchOrWarehouseId() {
            this.updateUrl(SUPPLIER_REPORT);
        },
    },
}